#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	
	

	[TestFixture]
	public class BOL_DailyControl : BaseTest 
	{
		private BOL.DailyControl _tstDC;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			System.Guid dcGuid = DataCreator.GetRecordGuid("SELECT TOP 1 DailyControlGuid FROM DailyControl WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
			this._tstDC = new BOL.DailyControl(dcGuid);

			this._tstDC.SetInitialBrokenRules(BROKEN.FrmConfigureReagent.FormClassName, BROKEN.FrmConfigureReagent.RuleSets.DailyControl);
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(!this._tstDC.Equals(null));
			Assert.AreEqual(this._tstDC,this._tstDC);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{	
			DataRow dr = DAL.DailyControl.GetDailyControl().Rows[0];
			BOL.DailyControl dc = new BOL.DailyControl(dr);

			Assert.IsNotNull(dc);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail()
		{	
			this._tstDC = new BOL.DailyControl(new DataTable().NewRow());
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 DailyControlGuid FROM DailyControl WHERE RecordStatusCode = 'A'" );
			//
			BOL.DailyControl dc = new DailyControl( (Guid)dr[TABLES.DailyControl.DailyControlGuid] );
			//
			Assert.IsNotNull( dc );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}

		[Test]
		public void DailyControlGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstDC.DailyControlGuid = tstValue;

			Assert.AreEqual(this._tstDC.DailyControlGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DailyControlGuid_Fail()
		{
		}
		
	
		[Test]
		public void NumberOfRacks_Pass()
		{
			System.Int32 _NumberOfRacks = this._tstDC.NumberOfRacks;
			Assert.AreEqual( this._tstDC.NumberOfRacks, _NumberOfRacks );

			int brokenRulesBefore = this._tstDC.BrokenRulesCount;
			this._tstDC.NumberOfRacks = 10;
			int brokenRulesAfter = this._tstDC.BrokenRulesCount;

			Assert.IsTrue( brokenRulesAfter < brokenRulesBefore );
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void NumberOfRacks_Fail()
		{
			this._tstDC.NumberOfRacks = -10;
			Assert.Fail( "Negative number was accepted as a number of racks and BusinessObjectException was not thrown as expected." );
		}

		[Test]
		public void RackNamesIndicator_Pass()
		{
			System.Boolean _RackNamesIndicator;
			_RackNamesIndicator = this._tstDC.RackNamesIndicator;
			Assert.AreEqual(this._tstDC.RackNamesIndicator,_RackNamesIndicator);
	
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=this._tstDC.BrokenRulesCount;
			this._tstDC.RackNamesIndicator= true;
			brokenRulesAfter=this._tstDC.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter< brokenRulesBefore);
		}

		[Test]
		public void RackNamesIndicator_Fail()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=this._tstDC.BrokenRulesCount;
			this._tstDC.RackNamesIndicator= false;
			brokenRulesAfter=this._tstDC.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		public void DailyAlertTime_Pass()
		{
			System.DateTime _DailyAlertTime;
			_DailyAlertTime = this._tstDC.DailyAlertTime;
			Assert.AreEqual(this._tstDC.DailyAlertTime,_DailyAlertTime);

			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=this._tstDC.BrokenRulesCount;
			this._tstDC.DailyAlertTime= BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			brokenRulesAfter=this._tstDC.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void DailyAlertTime_Fail()
		{
			this._tstDC.DailyAlertTime= DateTime.MinValue;
		}

		[Test]
		public void CommercialTemplateIndicator_Pass()
		{
			bool tmpValue = true;

			this._tstDC.CommercialTemplateIndicator = tmpValue;
			Assert.IsTrue(this._tstDC.CommercialTemplateIndicator == tmpValue);

			tmpValue = false;
			this._tstDC.CommercialTemplateIndicator = tmpValue;
			Assert.IsTrue(this._tstDC.CommercialTemplateIndicator == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CommercialTemplateIndicator_Fail()
		{
		}

		[Test]
		public void PrimaryEnhancementMedia_Pass()
		{
			BOL.EnhancementMedia tstValue = new BOL.EnhancementMedia();

			this._tstDC.PrimaryEnhancementMedia = tstValue;

			Assert.AreEqual(this._tstDC.PrimaryEnhancementMedia, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PrimaryEnhancementMedia_Fail()
		{
		}

		[Test]
		public void SecondaryEnhancementMedia_Pass()
		{
			BOL.EnhancementMedia tstValue = new BOL.EnhancementMedia();

			this._tstDC.SecondaryEnhancementMedia = tstValue;

			Assert.AreEqual(this._tstDC.SecondaryEnhancementMedia, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SecondaryEnhancementMedia_Fail()
		{
		}

		
		[Test]
		public void SaveAllDailyControlData_Pass()
		{
			BOL.DailyControl dc = new BOL.DailyControl(this._tstDC.DailyControlGuid);

			DataTable dtDailyControlData = DAL.DailyControl.GetDailyControl();
			DataTable dtReagentData = new DataTable();
			if(dtDailyControlData.Rows.Count > 0)
			{
				dtReagentData = DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, (bool) dtDailyControlData.Rows[0]["CommercialTemplateIndicator"]);
			}
			
			System.Collections.ArrayList alReagentTypes = new ArrayList();
			alReagentTypes.Add(new ReagentType(dtReagentData.Rows[0]));

			dc.PopulateRackData(dc.DailyControlGuid);
			dtDailyControlData.Rows[0]["SecondaryEnhancementMediaId"] = 1;
			Assert.AreEqual(true, dc.SaveAllDailyControlData(alReagentTypes, true, Common.UpdateFunction.UnitTests));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SaveAllDailyControlData_Fail()
		{
		}

		[Test]
		public void PopulateRackData_Pass()
		{
			int nExistingNumRacks = int.MinValue;
			DataTable dtDailyControlData = DAL.DailyControl.GetDailyControl();
			DataTable dtRackData = new DataTable();
			if(dtDailyControlData.Rows.Count > 0)
			{
				dtRackData = DAL.Rack.GetConfigurableRackQC((System.Guid) dtDailyControlData.Rows[0]["DailyControlGuid"]);
				nExistingNumRacks = dtRackData.Rows.Count;
				int nDiff= 26 - nExistingNumRacks;
				
				this._tstDC.NumberOfRacks = nExistingNumRacks + nDiff;
				
				this._tstDC.PopulateRackData((System.Guid) dtDailyControlData.Rows[0]["DailyControlGuid"]);
				Assert.IsTrue(this._tstDC.NumberOfRacks>0);
			}
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void PopulateRackData_Fail()
		{
			this._tstDC.PopulateRackData(Guid.Empty);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{	
			DataTable dt = DAL.DailyControl.GetDailyControl();
			DataRow dr = dt.NewRow();
			dr = this._tstDC.LoadDataRowFromThis(dr);
			Assert.AreEqual(this._tstDC.DailyAlertTime, (DateTime) dr[TABLES.DailyControl.DailyAlertTime]);
			Assert.AreEqual(this._tstDC.DailyControlGuid, (Guid) dr[TABLES.DailyControl.DailyControlGuid]);
			Assert.AreEqual(this._tstDC.NumberOfRacks, (int) dr[TABLES.DailyControl.NumberOfRacks]);
			Assert.AreEqual(this._tstDC.RackNamesIndicator, (bool) dr[TABLES.DailyControl.RackNamesIndicator]);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail()
		{	
			this._tstDC = new BOL.DailyControl(new DataTable().NewRow());
		}
		

		[Test]
		public void RecordStatusCode_Pass()
		{
			this._tstDC.RecordStatusCode=Common.RecordStatusCode.Historical;

			Assert.IsTrue(this._tstDC.RecordStatusCode==Common.RecordStatusCode.Historical);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void GetExistingDailyControlTemplate_Pass()
		{
			BOL.DailyControl tmpDC=this._tstDC.GetExistingDailyControlTemplate();

			Assert.IsNotNull(tmpDC);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetExistingDailyControlTemplate_Fail()
		{
		}

		[Test]
		public void PartiallyCompletedQC_Pass()
		{
			//Setup the data ------
			DataTable dtDQW = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM DailyQcWorklist WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A'", false);
			if (dtDQW.Rows.Count == 0)
			{
				UnitTestUtil.RunSQL("UPDATE DailyQcWorklist SET RecordStatusCode = 'A' WHERE DailyQcWorklistGuid = (SELECT TOP 1 DailyQcWorklistGuid FROM DailyQcWorklist WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'X' ORDER BY LastUpdateDate DESC)");
				dtDQW = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM DailyQcWorklist WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A'", true);
			}
			UnitTestUtil.RunSQL("UPDATE RACK SET RecordStatusCode = 'A' WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'X'");
			UnitTestUtil.RunSQL("UPDATE DailyControl SET RecordStatusCode = 'A' WHERE DailyControlGuid IN (SELECT DailyControlGuid FROM Rack WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A')");
			UnitTestUtil.RunSQL("UPDATE DailyQcWorklist SET DailyQcExpirationDate = GETUTCDATE() WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A'");

			DataTable dtRacks = BOL.Rack.GetDailyQCRacks(DateTime.Now.Date);
			System.Guid rackGuid = (System.Guid)dtRacks.Rows[0][TABLES.Rack.RackGuid];

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABOForwardTypingUnit);
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AntigenPhenotypingSingleTestPhaseQC);
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.DATQC);

			Common.WorkloadProcessID[] workloadProcessIds  = new Common.WorkloadProcessID[3];
			workloadProcessIds[0] = Common.WorkloadProcessID.ABOForwardTypingUnit;
			workloadProcessIds[1] = Common.WorkloadProcessID.AntigenPhenotypingSingleTestPhaseQC;
			workloadProcessIds[2] = Common.WorkloadProcessID.DATQC;
			BOL.RackLot.SaveRackTests(new DataTable(), rackGuid, new byte[0], true, UnitTestConfig.TestDivisionCode, Common.UpdateFunction.UnitTests, workloadProcessIds, Environment.UserName, DateTime.Now, DateTime.Now.Date, Guid.Empty);
			//
			Assert.AreEqual(true,BOL.DailyControl.PartiallyCompletedQC(),"PartiallyCompletedRacks");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PartiallyCompletedQC_Fail()
		{
		}
	}
}
#endif




